
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/monolithseva.zip" ),
}
local prefabs = {}

local start_inv = {
"monolith_seva",
"scroll",
"monolithbadge",
}


local function CalcSanityAura(inst)
    return -TUNING.SANITYAURA_LARGE
end


local fn = function(inst)
	
	inst.soundsname = "maxwell"
	
	inst.components.sanity.neg_aura_mult = 0
	--inst:AddComponent("petleash")
	--inst.components.petleash:SetMaxPets(4)
	
	local monolith_seva = Ingredient( "monolith_seva", 1)
monolith_seva.atlas = "images/inventoryimages/monolith_seva.xml"
local armor_device = Recipe("monolith_seva", { Ingredient("goldnugget", 23), monolith_seva }, RECIPETABS.REFINE, {REFINE=0})
armor_device.atlas = "images/inventoryimages/monolith_seva.xml"

	
	local badge_recipe = Recipe("monolithbadge", {Ingredient("goldnugget", 2), Ingredient("monstermeat", 1), Ingredient("silk", 1)}, RECIPETABS.TOWN, TECH.NONE)
	badge_recipe.sortkey = 1
	badge_recipe.atlas = "images/inventoryimages/monolithbadge.xml"
	STRINGS.RECIPE_DESC.MONOLITHBADGE = "Your tool for preaching\nto the spiders."
	
	local nest_recipe = Recipe("spidereggsack", {Ingredient("silk", 12), Ingredient("spidergland", 6), Ingredient("papyrus", 6)}, RECIPETABS.TOWN, TECH.NONE)
	nest_recipe.sortkey = 1
	STRINGS.RECIPE_DESC.SPIDEREGGSACK = "Get a little help from your friends."
	
	inst:AddTag("spiderwhisperer")
	inst:AddTag("merm")
	inst:AddTag("monolith")
	inst:AddTag("stalker")
	inst.components.locomotor.triggerscreep = false
	inst.MiniMapEntity:SetIcon( "monolithseva.tex" )
	
	inst.components.builder.science_bonus = 1
	
	inst.components.eater.ignoresspoilage = true
	inst.components.eater.monsterimmune = true
	
	inst:AddTag("monster")
	
	inst:AddComponent("sanityaura")
    inst.components.sanityaura.aurafn = CalcSanityAura

	-- Stats	
	inst.components.health:SetMaxHealth(175)
	inst.components.hunger:SetMax(175)
	inst.components.sanity:SetMax(100)
	
	
end

return MakePlayerCharacter("monolithseva", prefabs, assets, fn, start_inv)
